import json
import itertools
import logging

from sandbox.projects.yabs.qa.response_tools.parse_json import try_parse_json


logger = logging.getLogger(__name__)


def validate_json(text, context_size=3, **demjson_kwargs):
    import demjson

    result = []

    try:
        json.loads(text)
    except:
        pass
    else:
        return result

    import jsbeautifier

    beautiful_text = jsbeautifier.beautify(text)
    text_lines = beautiful_text.splitlines()

    _, errors = try_parse_json(beautiful_text, jsonp_parser=demjson.decode, return_errors=True, **demjson_kwargs)

    for error in errors:
        if isinstance(error.position, demjson.position_marker):
            error_line_number = error.position.line
        elif isinstance(error.position, int):
            error_line_number = error.position
        else:
            error_line_number = None

        if error_line_number is None:
            from_line = 0
            to_line = len(text_lines) - 1
        else:
            from_line = max(0, error_line_number - context_size - 1)
            to_line = error_line_number + context_size - 1

        error_line_with_context = '\n'.join([
            "{mark} | {line}".format(
                mark=' ->' if line_number == error_line_number else ' ' * 3,
                line=line.encode('utf-8'),
            )
            for line_number, line
            in enumerate(itertools.islice(text_lines, from_line, to_line + 1),
                         start=from_line + 1)
        ])

        result.append((error, error_line_with_context))

    return result
