import json
import textwrap

from sandbox import sdk2
from sandbox.projects.yabs.qa.tasks.YtOneshot.base_tasks.base_oneshot import BaseYtOneshot, _generate_ya_make_file_content


def _generate_constant_oneshot(table_path, mode_str, data):
    oneshot_code_template = textwrap.dedent("""\
        from yabs.qa.oneshots.constants import AbstractConstantYtOneshot

        from yabs.qa.yt_oneshot import run_oneshot, EYtOneshotMode


        class Oneshot(AbstractConstantYtOneshot):
            table_path = '{table_path}'
            mode = EYtOneshotMode.{mode}
            query_data = {data}


        def main():
            run_oneshot(Oneshot)
    """)
    return oneshot_code_template.format(table_path=table_path,
                                        mode=mode_str,
                                        data='    '.join(json.dumps(data, indent=4).replace(' \n', '\n').splitlines(True)))


class ConstantYtOneshot(BaseYtOneshot):

    BSINT_REVIEW_GROUP = 'server-constant'

    class Parameters(BaseYtOneshot.Parameters):
        with sdk2.parameters.RadioGroup('Action type', required=True) as action_type:
            action_type.values.add = action_type.Value('Add')
            action_type.values.update = action_type.Value('Update')
            action_type.values.delete = action_type.Value('Delete')
        with sdk2.parameters.Group('Oneshot data') as oneshot_data:
            with action_type.value['delete']:
                constant_names = sdk2.parameters.String('Names (comma-separated)', required=True)
            with action_type.value['add'], action_type.value['update']:
                constant_name = sdk2.parameters.String('Name', required=True)
                constant_value = sdk2.parameters.Integer('Value', required=True)
                constant_description = sdk2.parameters.String('Description', required=True)

    def generate_oneshot_file_content(self):
        if self.Parameters.action_type == 'delete':
            data = [
                {
                    'ContentSystemKey': 0,
                    'Name': constant_name.strip(),
                }
                for constant_name in self.Parameters.constant_names.split(",")
            ]
            return _generate_constant_oneshot(self.table_path, 'DELETE', data)

        constant_description = self.Parameters.constant_description
        if self.Parameters.ticket not in constant_description:
            constant_description = "{}: {}".format(self.Parameters.ticket, constant_description)

        data = {
            'ContentSystemKey': 0,
            'Name': self.Parameters.constant_name,
            'Value': self.Parameters.constant_value,
            'Description': constant_description,
        }

        if self.Parameters.action_type == 'add':
            return _generate_constant_oneshot(self.table_path, 'INSERT', data)

        if self.Parameters.action_type == 'update':
            return _generate_constant_oneshot(self.table_path, 'UPDATE', data)

        raise ValueError('Unknown action type: {}'.format(self.Parameters.action_type))

    def generate_ya_make_file_content(self):
        return _generate_ya_make_file_content(self.author, ('yabs/qa/oneshots/constants', 'yabs/qa/yt_oneshot'))
