import textwrap
import json

from sandbox import sdk2
from sandbox.projects.yabs.qa.tasks.YtOneshot.base_tasks.base_oneshot import BaseYtOneshot, _generate_ya_make_file_content


def _generate_cud_oneshot(table_path, mode_str, data):
    oneshot_code_template = textwrap.dedent('''\
        from yabs.qa.yt_oneshot import AbstractCudYtOneshot, run_oneshot, EYtOneshotMode


        class Oneshot(AbstractCudYtOneshot):
            table_path = "{table_path}"
            mode = EYtOneshotMode.{mode}
            query_data = {data}


        def main():
            run_oneshot(Oneshot)
    ''')
    return oneshot_code_template.format(
        table_path=table_path,
        mode=mode_str,
        data='    '.join(json.dumps(data, indent=4, ensure_ascii=False).replace(' \n', '\n').splitlines(True)),
    )


class CudYtOneshot(BaseYtOneshot):
    class Parameters(BaseYtOneshot.Parameters):
        with sdk2.parameters.RadioGroup('Action type', required=True) as action_type:
            action_type.values.add = action_type.Value('Add')
            action_type.values.update = action_type.Value('Update')
            action_type.values.delete = action_type.Value('Delete')

        table_path = sdk2.parameters.String('Table path', required=True)
        oneshot_data = sdk2.parameters.JSON('Oneshot data', required=True)

    def generate_oneshot_file_content(self):
        data = self.Parameters.oneshot_data
        if isinstance(data, dict):
            data = [data]

        if self.Parameters.action_type == 'delete':
            return _generate_cud_oneshot(self.Parameters.table_path, 'DELETE', data)

        if self.Parameters.action_type == 'add':
            return _generate_cud_oneshot(self.Parameters.table_path, 'INSERT', data)

        if self.Parameters.action_type == 'update':
            return _generate_cud_oneshot(self.Parameters.table_path, 'UPDATE', data)

        raise ValueError('Unknown action type: {}'.format(self.Parameters.action_type))

    def generate_ya_make_file_content(self):
        return _generate_ya_make_file_content(self.author, ('yabs/qa/yt_oneshot', ))
