import textwrap

from sandbox import sdk2
from sandbox.projects.yabs.qa.tasks.YtOneshot.base_tasks.base_oneshot import BaseYtOneshot, _generate_ya_make_file_content


def _generate_keyword_oneshot(mode_str, data):
    oneshot_code_template = textwrap.dedent('''\
        from yabs.qa.yt_oneshot import run_oneshot, EYtOneshotMode
        from yabs.qa.oneshots.keywords import AbstractKeywordYtOneshot


        class Oneshot(AbstractKeywordYtOneshot):
            mode = EYtOneshotMode.{mode}
            query_data = {data}


        def main():
            run_oneshot(Oneshot)
    ''')
    return oneshot_code_template.format(mode=mode_str, data=str(data))


class KeywordTypeYtOneshot(BaseYtOneshot):
    class Parameters(BaseYtOneshot.Parameters):
        with sdk2.parameters.RadioGroup('Action type', required=True) as action_type:
            action_type.values.add = action_type.Value('Add')
            action_type.values.update = action_type.Value('Update')
            action_type.values.delete = action_type.Value('Delete')

        oneshot_data = sdk2.parameters.JSON(
            'Oneshot data (at least Type and Data fields are required)',
            required=True,
            default=[
                {"Type": "", "Data": ""}
            ]
        )

    def generate_oneshot_file_content(self):
        data = self.Parameters.oneshot_data
        if isinstance(data, dict):
            data = [data]

        if self.Parameters.action_type == 'delete':
            return _generate_keyword_oneshot('DELETE', data)

        if self.Parameters.action_type == 'add':
            return _generate_keyword_oneshot('INSERT', data)

        if self.Parameters.action_type == 'update':
            return _generate_keyword_oneshot('UPDATE', data)

        raise ValueError('Unknown action type: {}'.format(self.Parameters.action_type))

    def generate_ya_make_file_content(self):
        return _generate_ya_make_file_content(self.author, ('yabs/qa/oneshots/keywords', 'yabs/qa/yt_oneshot'))
