from sandbox import sdk2


class CriticalParametersDiffHandleMode(object):
    mark_as_diff = 'mark_as_diff'
    fail_task = 'fail_task'
    do_nothing = 'do_nothing'


class BaseCompareTaskParameters(sdk2.Parameters):
    with sdk2.parameters.Group("Testenv info") as testenv_block:
        test_name = sdk2.parameters.String("Testenv test name")
        pre_revision = sdk2.parameters.Integer("Pre revision")
        test_revision = sdk2.parameters.Integer("Test revision")
        arcanum_review_id = sdk2.parameters.Integer("Arcanum review id", default=0)
        binary_search_helper = sdk2.parameters.Bool('Help with binary search', default=False, do_not_copy=True)

    with sdk2.parameters.Group('Pre data') as pre_block:
        pre_task_id = sdk2.parameters.Task('Pre task id (deprecated, used only to preserve pre_task id in older tasks)')  # deprecated TODO BSSERVER-14420 igorock@
        pre_task = sdk2.parameters.Task('Pre task')

    with sdk2.parameters.Group('Test data') as test_block:
        test_task_id = sdk2.parameters.Task('Test task id (deprecated, used only to preserve test_task id in older tasks)')  # deprecated TODO: BSSERVER-14420 igorock@
        test_task = sdk2.parameters.Task('Test task')

    with sdk2.parameters.Group('Comparison options') as comparison_block:
        compare_input_parameters = sdk2.parameters.Bool('Compare input parameters', default=True)
        with compare_input_parameters.value[True]:
            critical_parameters_mode = sdk2.parameters.String(
                'How to handle different critical input parameters',
                choices=(
                    (CriticalParametersDiffHandleMode.mark_as_diff, CriticalParametersDiffHandleMode.mark_as_diff),
                    (CriticalParametersDiffHandleMode.fail_task, CriticalParametersDiffHandleMode.fail_task),
                    (CriticalParametersDiffHandleMode.do_nothing, CriticalParametersDiffHandleMode.do_nothing),
                ),
                default=CriticalParametersDiffHandleMode.mark_as_diff,
            )
    with sdk2.parameters.Output:
        has_diff = sdk2.parameters.Bool("Pre and test differ from each other")
        st_report = sdk2.parameters.String("Startrek-formatted diff report")
