import time

from contextlib import contextmanager

from sandbox import sdk2


class BaseDurarionMeasureTaskParameters(sdk2.Parameters):
    with sdk2.parameters.Output:
        durations = sdk2.parameters.JSON('Durations of stages', default={})


class BaseDurarionMeasureTask(object):
    @contextmanager
    def stage_duration(self, stage_name):
        if not hasattr(self, 'stage_durations'):
            self.stage_durations = {}

        start = int(time.time())
        yield
        finish = int(time.time())

        self.stage_durations.update({
            stage_name: {
                "start": start,
                "finish": finish,
                "duration": finish - start,
            }
        })

    def on_finish(self, prev_status, status):
        try:
            self.Parameters.durations = self.stage_durations
        except AttributeError:
            pass
