import os
import logging
from functools import partial
from jinja2 import Environment, FunctionLoader


logger = logging.getLogger(__name__)


def load_template(template_name, templates_dir='.'):
    template_path = os.path.normpath(
        os.path.join(
            templates_dir,
            template_name,
        )
    )
    logger.debug("Load template from %s", template_path)
    try:
        import library.python.resource as lpr
    except ImportError:
        with open(template_path, 'r') as f:
            template_text = f.read()
    else:
        template_text = lpr.find(template_path).decode('utf-8')

    return template_text


def get_template(template_name, templates_dir='.', **kwargs):
    if 'loader' not in kwargs:
        loader_func = partial(load_template, templates_dir=templates_dir)
        kwargs['loader'] = FunctionLoader(loader_func)
    env = Environment(**kwargs)
    return env.get_template(template_name)
