class Contextable(object):
    @classmethod
    def __from_context__(cls, context, second_batch=False):
        values = (getattr(context, (field + '_2' if second_batch else field), None) for field in cls._fields)
        return cls._make(values)

    def __to_context__(self, context, second_batch=False):
        for key, value in self._asdict().iteritems():
            setattr(context, (key + '_2' if second_batch else key), value)
