import dateutil
import logging
import os
try:
    from urllib import urlencode
    import urlparse
except ImportError:
    # python 3
    from urllib.parse import urlencode
    from urllib.parse import urlparse

from sandbox.sdk2.vcs import svn


logger = logging.getLogger(__name__)


def get_arcadia_file_extension(arcadia_url):
    oneshot_parsed_url = svn.Arcadia.parse_url(arcadia_url)
    logger.debug('Oneshot URL: %s', oneshot_parsed_url)
    return os.path.splitext(oneshot_parsed_url.path)[1]


def get_arcanum_url(arcadia_url):
    parsed_url = svn.Arcadia.parse_url(arcadia_url)
    arcanum_url = urlparse.urljoin('https://a.yandex-team.ru', parsed_url.path)
    if parsed_url.revision:
        url_parts = urlparse.urlparse(arcanum_url)._replace(query=urlencode({'rev': parsed_url.revision}))
        arcanum_url = urlparse.urlunparse(url_parts)
    return arcanum_url


def get_revision_datetime(revision):
    arc_url = svn.Arcadia.trunk_url(revision=revision)
    commit_date = svn.Arcadia.info(arc_url)["date"]
    return dateutil.parser.parse(commit_date).replace(tzinfo=None)
