import logging

from sandbox.projects.common import decorators
from sandbox.projects.release_machine.helpers import arcanum_helper


logger = logging.getLogger(__name__)


@decorators.retries(max_tries=2, delay=10)
def comment_review(arcanum_token, review_id, comment):
    arcanum_api = arcanum_helper.ArcanumApi(token=arcanum_token)
    arcanum_api.comment_review(review_id, comment=comment)
