import logging
import re


logger = logging.getLogger(__name__)


BASE_NAME_PATTERN = re.compile(r'(?P<base_ver>[0-9]+)\.(?P<base_name>[a-z_0-9]+)\..*')
BASES_DIR = 'bases'


def parse_base_filename(filename):
    match = BASE_NAME_PATTERN.match(filename)
    if not match:
        return None, None
    match_dict = match.groupdict()
    return match_dict["base_ver"], match_dict["base_name"]


def get_bstr_info(bases, base_ver, yt_client, path):
    from yt.wrapper import ypath_join

    bstr_info = {}
    for base_file in yt_client.list(path):
        current_base_ver, current_base_name = parse_base_filename(base_file)

        if not all((current_base_ver, current_base_name)):
            logger.warning('Failed to parse base_ver and name from \'%s\'', base_file)
            continue

        if current_base_ver != base_ver or current_base_name not in bases:
            continue

        bstr_info[current_base_name] = yt_client.get_attribute(ypath_join(path, base_file), '_bstr_info')
    return bstr_info
