import logging
import multiprocessing
import uuid

from sandbox import sdk2
from sandbox.projects.yabs.sandbox_task_tracing.wrappers import subprocess


logger = logging.getLogger(__name__)


def check_proto(dump_parser_path, dump_path, check_ext_tags, hamster_ext_service_tags=(), threads=0):
    _uuid = str(uuid.uuid4())
    bad_requests_path = _uuid + '.bad_requests'
    statuses_output = _uuid + '.statuses'
    cmdline = [
        dump_parser_path,
        '--check-proto',
        '-r', bad_requests_path,
        '--ignore-bad-phantom',
        '--check-ext-tags', ','.join(check_ext_tags),
        '-j', str(threads or multiprocessing.cpu_count()),
        '-o', statuses_output,
        dump_path,
    ]
    if hamster_ext_service_tags:
        cmdline.extend(['--hamster-ext-tags', ','.join(hamster_ext_service_tags)])
    cmdline.extend(['--http-codes-to-reshoot', '504'])
    logger.debug('Running %s', ' '.join(cmdline))
    with sdk2.helpers.ProcessLog('get_bad_requests') as process_log_context:
        process_log_context.logger.propagate = True
        bad_response_parser_output = subprocess.check_output(cmdline, stderr=process_log_context.stderr)
    logging.getLogger('process.get_bad_requests').info(bad_response_parser_output)
    return bad_requests_path, bad_response_parser_output, statuses_output


def get_original_request_id(count_request_id):
    """Get original request id from /count request id

    :param count_request_id: /count request id
    :type count_request_id: str
    :return: Original request id or None if any error occured
    :rtype: str
    """
    if not count_request_id.isdigit():
        return None

    # strip last 13 symbols to get original request id: 2 symbols for suffix counter, 11 symbols for suffix hash
    # https://a.yandex-team.ru/arc_vcs/yabs/server/tools/dolbilo2json/lib/count_link.cpp?rev=0cd4890f574f48e8535d72ae28b653b572e25c28#L93
    original_test_id = count_request_id[:-13]
    if not original_test_id:
        return None

    return original_test_id
