from collections import namedtuple

from sandbox.projects.yabs.qa.constants import MB_IN_GB, B_IN_MB
from sandbox.projects.yabs.qa.utils.base import get_bin_bases_unpacked_size_fast, get_bin_bases_packed_size


ShootRequirements = namedtuple(
    'ShootRequirements',
    (
        'ram',
        'ramdrive_size',
        'disk_space',
        'bin_bases_unpacked_size',
    )
)


def get_shoot_requirements(sandbox_rest_client, parameters):
    ram = parameters.ram_space * MB_IN_GB

    bin_bases_unpacked_size = get_bin_bases_unpacked_size_fast(sandbox_rest_client, parameters.meta_binary_base_resources + parameters.stat_binary_base_resources)
    bin_bases_unpacked_total_size = sum(bin_bases_unpacked_size)
    bin_bases_packed_size = get_bin_bases_packed_size(sandbox_rest_client, parameters.meta_binary_base_resources + parameters.stat_binary_base_resources)
    bin_bases_packed_total_size = sum(bin_bases_packed_size)

    ext_stubs_cachedaemon_data_size = 0
    if parameters.cache_daemon_stub_resource:
        ext_stubs_cachedaemon_data_size = int(parameters.cache_daemon_stub_resource.size)

    ramdrive_size = ext_stubs_cachedaemon_data_size / B_IN_MB + 10 * MB_IN_GB
    disk_space = (
        parameters.generic_disk_space * MB_IN_GB
        + bin_bases_packed_total_size / B_IN_MB
        + ext_stubs_cachedaemon_data_size / B_IN_MB
    )
    if parameters.use_tmpfs:
        ramdrive_size += bin_bases_unpacked_total_size / B_IN_MB
    else:
        disk_space += bin_bases_unpacked_total_size / B_IN_MB

    return ShootRequirements(ram=ram, ramdrive_size=ramdrive_size, disk_space=disk_space, bin_bases_unpacked_size=bin_bases_unpacked_size)


def get_performance_meta_2_on_1_requirements(sandbox_rest_client, parameters):
    ram = parameters.ram_space * MB_IN_GB

    bin_bases_unpacked_size = max(
        get_bin_bases_unpacked_size_fast(sandbox_rest_client, parameters.meta_binary_base_resources),
        get_bin_bases_unpacked_size_fast(sandbox_rest_client, parameters.meta_binary_base_resources_2),
        key=sum
    )
    bin_bases_unpacked_total_size = sum(bin_bases_unpacked_size)

    bin_bases_packed_size = max(
        get_bin_bases_packed_size(sandbox_rest_client, parameters.meta_binary_base_resources),
        get_bin_bases_packed_size(sandbox_rest_client, parameters.meta_binary_base_resources_2),
        key=sum
    )
    bin_bases_packed_total_size = sum(bin_bases_packed_size)

    ext_stubs_cachedaemon_data_size = 0
    if parameters.cache_daemon_stub_resource and parameters.cache_daemon_stub_resource_2:
        ext_stubs_cachedaemon_data_size = max(int(parameters.cache_daemon_stub_resource.size), int(parameters.cache_daemon_stub_resource_2.size))

    stat_stubs_cachedaemon_data_size = 0
    if parameters.stat_stub_data and parameters.stat_stub_data_2:
        stat_stubs_cachedaemon_data_size = max(int(parameters.stat_stub_data.size), int(parameters.stat_stub_data_2.size))

    ramdrive_size = (stat_stubs_cachedaemon_data_size + ext_stubs_cachedaemon_data_size) / B_IN_MB + 10 * MB_IN_GB
    disk_space = (
        parameters.generic_disk_space * MB_IN_GB
        + bin_bases_packed_total_size / B_IN_MB
        + ext_stubs_cachedaemon_data_size / B_IN_MB
    )
    if parameters.use_tmpfs:
        ramdrive_size += bin_bases_unpacked_total_size / B_IN_MB
    else:
        disk_space += bin_bases_unpacked_total_size / B_IN_MB

    return ShootRequirements(ram=ram, ramdrive_size=ramdrive_size, disk_space=disk_space, bin_bases_unpacked_size=bin_bases_unpacked_size)
