import logging
import os
import subprocess

from sandbox.projects.yabs.qa.module_base import ModuleBase
from sandbox.sdk2.helpers import ProcessLog


class ShootResultsYtUploaderModule(ModuleBase):

    def __init__(self, adapter):
        ModuleBase.__init__(self, adapter)
        self._yt_uploader_executable_path = self.adapter.get_yt_uploader_executable_path()

    def upload_results(self, results_path, yt_table_path=None, ttl_days=None):
        """
        Runs processor on provided results
        :param results_path: results to process
        :param yt_table_path: yt table to create
        :param ttl_days: yt table ttl
        :return:
        """
        logging.info('Running yt_uploader on {0}'.format(results_path))
        yt_table_path = yt_table_path if yt_table_path is not None else self.adapter.get_yt_table_path()
        process_args = ['--result-path', yt_table_path, results_path]
        assert yt_table_path, 'Could not infer table path'
        ttl_days = ttl_days if ttl_days is not None else self.adapter.get_yt_ttl_days()
        if ttl_days:
            process_args += ['--ttl', str(ttl_days)]

        # set environment
        env = os.environ.copy()
        env.update({
            'YT_TOKEN': self.adapter.get_yt_token()
        })

        with ProcessLog(self.adapter.task_instance, logger='yt_uploader_log') as process_log_context:
            process = subprocess.Popen(
                [self._yt_uploader_executable_path] + process_args,
                stdout=process_log_context.stdout,
                stderr=subprocess.STDOUT,
                env=env,
            )
            process.communicate()
        return yt_table_path
