import os

from sandbox.projects.yabs.qa.yt_uploader_module import ShootResultsYtUploaderModule
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase

from sandbox.projects.yabs.qa.yt_uploader_module.adapters.interface import \
    ShootResultsYtUploaderAdapterInterface
from parameters import ShootResultsYtUploaderGenericParameters, EYtUploaderResourceType
from sandbox.projects.common.yabs.server.util.general import try_get_from_vault

import tarfile
import uuid


YT_UPLOADER_EXECUTABLE_NAME = 'yt_uploader'


class ShootResultsYtUploaderGenericSandboxAdapter(ShootResultsYtUploaderAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    def get_yt_uploader_executable_path(self):
        resource_path = self.sync_resource(self.parameters.yt_uploader_resource)
        if self.parameters.yt_uploader_resource_type == EYtUploaderResourceType.tar.name:
            with tarfile.open(resource_path) as tar:
                tar.extractall(self.get_work_dir())
            return os.path.join(self.get_work_dir(), YT_UPLOADER_EXECUTABLE_NAME)
        elif self.parameters.yt_uploader_resource_type == EYtUploaderResourceType.plain.name:
            return resource_path

    def get_yt_token(self):
        return try_get_from_vault(self.task_instance, self.parameters.yt_token_vault_key)

    @staticmethod
    def get_work_dir():
        return os.getcwd()

    def get_yt_table_path(self):
        if self.parameters.yt_table_prefix:
            return self.parameters.yt_table_prefix + ('/' if not self.parameters.yt_table_prefix.endswith('/') else '') + str(uuid.uuid4())
        else:
            return None

    def get_yt_ttl_days(self):
        return self.parameters.yt_ttl_days

    @staticmethod
    def get_init_parameters_class():
        return ShootResultsYtUploaderGenericParameters

    def create_module(self):
        return ShootResultsYtUploaderModule(self)
