from sandbox import sdk2

from enum import Enum
from sandbox.projects.yabs.qa.resource_types import BaseBackupSdk2Resource


class EYtUploaderResourceType(Enum):
    tar = 1
    plain = 2


class GenericDolbiloToYtUploader(BaseBackupSdk2Resource):
    service = None


class ShootResultsYtUploaderGenericParameters(sdk2.Task.Parameters):
    yt_uploader_resource = sdk2.parameters.LastReleasedResource(
        "Shoot task results YT uploader (last released used by default)",
        resource_type=GenericDolbiloToYtUploader,
        required=True
    )
    yt_uploader_resource_type = sdk2.parameters.String(
        "YT uploader resource type",
        choices=[(x.name, x.name) for x in EYtUploaderResourceType],
        default=EYtUploaderResourceType.tar.name
    )
    yt_table_prefix = sdk2.parameters.String(
        "YT table prefix"
    )
    yt_token_vault_key = sdk2.parameters.String(
        "YT token vault key"
    )
    yt_ttl_days = sdk2.parameters.Integer(
        "TTL for the resulting table"
    )
