# coding: utf-8

from .names import AggregationPrefixes
from .types import Aggregations
from .types import PercentilesDescription


def get_fabric_name(name):
    return name + 'Fabric'


Percentiles = (
    PercentilesDescription(
        ColumnPrefix='P100_',
        Value='1',
        Label='p100',
    ),
    PercentilesDescription(
        ColumnPrefix='P999_',
        Value='0.999',
        Label='p99.9',
    ),
    PercentilesDescription(
        ColumnPrefix='P99_',
        Value='0.99',
        Label='p99',
    ),
    PercentilesDescription(
        ColumnPrefix='P95_',
        Value='0.95',
        Label='p95',
    ),
    PercentilesDescription(
        ColumnPrefix='P90_',
        Value='0.90',
        Label='p90',
    ),
    PercentilesDescription(
        ColumnPrefix='P70_',
        Value='0.70',
        Label='p70',
    ),
    PercentilesDescription(
        ColumnPrefix='P50_',
        Value='0.5',
        Label='p50',
    ),
    PercentilesDescription(
        ColumnPrefix='P25_',
        Value='0.25',
        Label='p25',
    ),
    PercentilesDescription(
        ColumnPrefix='P10_',
        Value='0.1',
        Label='p10',
    ),
    PercentilesDescription(
        ColumnPrefix='P0_',
        Value='0',
        Label='p0',
    ),
)

AggregationsList = (
    Aggregations(
        FactoryParam='"AVG"',
        Prefix=AggregationPrefixes.AVG,
    ),
) + tuple(
    Aggregations(
        FactoryParam='"PERCENTILE", {}'.format(percentile.Value),
        Prefix=percentile.ColumnPrefix,
    ) for percentile in Percentiles
)
