from .aggregations import AggregationsList


class DefinitionInterface(object):
    Name = None

    @classmethod
    def get_text(cls, task):
        raise NotImplementedError()


class DefinitionTextInterface(DefinitionInterface):
    Text = None

    @classmethod
    def get_text(cls, task):
        return cls.Text.format(name=cls.Name)


class AggregationsDefinition(DefinitionTextInterface):
    Name = 'AggregationsFabrics'
    Text = '\n'.join('${aggr.Prefix}Factory = AggregationFactory({aggr.FactoryParam});'.format(
        aggr=aggr
    ) for aggr in AggregationsList)


class DeleteUnfinitedColumnsDefinition(DefinitionTextInterface):
    Name = 'DeleteUnfinitedColumnsDefinition'
    Text = '''${name} = ($x) -> {{
    RETURN IF(Math::IsFinite($x), $x, NULL);
}};'''


class BitsToSetDefinition(DefinitionTextInterface):
    Name = 'BitsToSetDefinitions'
    Text = '''${name} = ($x_any) -> {{
    $x = CAST($x_any AS UINT64);
    RETURN ToSet(
        ListMap(
            ListFilter(
                ListFromRange(0, 64),
                ($i) -> {{
                    RETURN CAST(ClickHouse::bitTest($x, $i) AS Bool)
                }}
            ),
            ($x) -> {{
                RETURN CAST($x AS STRING);
            }}
        )
    );
}};'''


class GetExperimentsSetDefinition(DefinitionTextInterface):
    Name = 'GetExperimentsSetDefinition'
    Text = '''${name} = ($ids) -> {{
    RETURN ToSet(ListMap(
        String::SplitToList($ids, ";"),
        ($id) -> {{
            RETURN String::SplitToList($id, ":")[0]
        }}
    ));
}};'''


class GetExperimentsDefinition(DefinitionInterface):
    Name = 'GetExperiments'
    Text = '''PRAGMA File("{name}FullExpsFile", "sbr://{full_exps_res_id}");
${name}FullExps = ListCollect(ParseFile("string", "{name}FullExpsFile"));
${name} = ($ids) -> {{
    RETURN ListFilter(
        ListMap(
            String::SplitToList($ids, ";"),
            ($id) -> {{
                RETURN String::SplitToList($id, ":")[0]
            }}
        ),
        ($id) -> {{
            RETURN $id not in ${name}FullExps;
        }}
    );
}};'''

    @classmethod
    def get_text(cls, task):
        return cls.Text.format(
            name=cls.Name,
            full_exps_res_id=task.get_full_exps_res_id(),
        )


Definitions = {
    definition.Name: definition
    for definition in (
        AggregationsDefinition,
        BitsToSetDefinition,
        DeleteUnfinitedColumnsDefinition,
        GetExperimentsDefinition,
        GetExperimentsSetDefinition,
    )
}
