# coding: utf-8

from .aggregations import AggregationsList
from .sources import SourcesDefinitions
from .types import GraphDescription
from .types import MultiSourceDescription
from .utils import iter_values_of_class


MULTI_AGGREGATION_SELECT_TMPL = 'SELECT {selects}, MULTI_AGGREGATE_BY(DataColumns, ${name}Factory) AS {name} FROM ${source_name} GROUP BY {groups_by}'
STAGES_GRAPH_GROUPING_LIST = ('StageName', 'PlaceSelect')
DATA_STAGES_GRAPH_GROUPING_LIST = STAGES_GRAPH_GROUPING_LIST + ('Data',)


def generate_on(grouping_list):
    return ' AND '.join(map(
        lambda x: '{{prev}}.{0} == {{curr}}.{0}'.format(x),
        grouping_list
    ))


class GraphsDefinitions(object):
    StagesStatsGraph = GraphDescription(
        Name='stages_stats_graph',
        Selects=('*',),
        SourceName=SourcesDefinitions.StagesStats.Name,
        MultiSources=(
            MultiSourceDescription(
                Name=aggr.Prefix,
                On=generate_on(STAGES_GRAPH_GROUPING_LIST),
                Select=MULTI_AGGREGATION_SELECT_TMPL.format(
                    groups_by=', '.join(STAGES_GRAPH_GROUPING_LIST),
                    name=aggr.Prefix,
                    selects=', '.join(STAGES_GRAPH_GROUPING_LIST),
                    source_name=SourcesDefinitions.StagesStats.Name,
                )
            ) for aggr in AggregationsList
        ),
        Postfixes=[],
    )
    GroupingStagesStatsGraph = GraphDescription(
        Name='grouping_stages_stats_graph',
        Selects=('*',),
        MultiSources=(
            MultiSourceDescription(
                Name=aggr.Prefix,
                On=generate_on(DATA_STAGES_GRAPH_GROUPING_LIST),
                Select=MULTI_AGGREGATION_SELECT_TMPL.format(
                    groups_by=', '.join(
                        STAGES_GRAPH_GROUPING_LIST + (
                            '{task.grouping_stages_stats_grouping_by} AS Data',
                        )
                    ),
                    name=aggr.Prefix,
                    selects=', '.join(DATA_STAGES_GRAPH_GROUPING_LIST),
                    source_name=SourcesDefinitions.StagesStats.Name,
                )
            ) for aggr in AggregationsList[1:]
        ),
        SourceName=SourcesDefinitions.StagesStats.Name,
        Postfixes=[],
    )
    StageTimingsGraph = GraphDescription(
        Name='stage_timings_graph',
        Selects=(
            'Stage',
            'HardHit',
            'COUNT(*) AS `Count`',
            'SUM(DurationMicroseconds) AS `SumDuration`',
        ),
        MultiSources=None,
        SourceName=SourcesDefinitions.StageTimingsLog.Name,
        Postfixes=(
            'GROUP BY Stage, HardHit',
        ),
    )
    PMatchFailsByExps = GraphDescription(
        Name='pmatch_fails_by_exps',
        Selects=(
            'ExpID',
            'PageLabel',
            'SUM(ClickHouse::bitCount(`PMatchFailBits`)) AS TotalPMatchBitsFails',
            'COUNT_IF(ClickHouse::bitCount(`PMatchFailBits`) >= 6) AS HalfPMatchFails',
            'COUNT_IF(ClickHouse::bitCount(`PMatchFailBits`) >= 12) AS AllPMatchFails',
        ),
        MultiSources=None,
        SourceName=SourcesDefinitions.PMatchFailsBitsByExps.Name,
        Postfixes=(
            'GROUP BY ExpID, PageLabel',
        ),
    )


Graphs = tuple(iter_values_of_class(GraphsDefinitions, GraphDescription))
