# coding: utf-8

from sandbox import sdk2
from sandbox.projects.yabs.yt_logfeller_sampler import YtLogFellerSamplers


class InputBaseInterface(object):
    Name = None

    @classmethod
    def iter_parameters(cls):
        raise NotImplementedError()


class DictionariesBase(InputBaseInterface):
    HumanName = None
    DefaultTablePath = None

    @classmethod
    def get_table_path_field(cls):
        return cls.Name + '_table_path'

    @classmethod
    def iter_parameters(cls):
        yield cls.get_table_path_field(), lambda: sdk2.parameters.String(
            label='Table path for {}'.format(cls.HumanName),
            default=cls.DefaultTablePath,
        )


SAMPLERS_DEFAULT_TEXT = 'default'
SamplersList = (
    YtLogFellerSamplers.Days,
    YtLogFellerSamplers.Hours,
)


class SamplerParams(sdk2.Parameters):
    with sdk2.parameters.RadioGroup('Sampler for {log_name}') as sampler:
        sampler.values[SAMPLERS_DEFAULT_TEXT] = sampler.Value(
            SAMPLERS_DEFAULT_TEXT,
            default=True,
        )
        for loc_sampler in SamplersList:
            sampler.values[loc_sampler.name] = sampler.Value(
                loc_sampler.name,
            )


class LogsBase(InputBaseInterface):
    HumanName = None
    DefaultPrefix = None
    DefaultSamplerName = None

    @classmethod
    def get_prefix_field(cls):
        return cls.Name + '_prefix'

    @classmethod
    def get_sampler_field(cls):
        return cls.Name + '_sampler_group'

    @classmethod
    def get_sampler_name(cls):
        return cls.Name + '_sampler'

    @classmethod
    def iter_parameters(cls):
        yield cls.get_prefix_field(), sdk2.parameters.String(
            label='Prefix to {log_name}'.format(log_name=cls.HumanName),
            required=True,
            default=cls.DefaultPrefix,
        )
        yield cls.get_sampler_field(), lambda: SamplerParams(
            prefix=cls.Name + '_',
            label_substs=dict(log_name=cls.HumanName),
        )


class PageDictionaryBase(DictionariesBase):
    Name = 'page'
    HumanName = 'Page'
    DefaultTablePath = '//home/yabs/dict/Page'


class StageStatsLogBase(LogsBase):
    Name = 'stages_stats_log'
    HumanName = 'bs-proto-stagestats-log'
    DefaultPrefix = '//logs/bs-proto-stagestats-log'
    DefaultSamplerName = YtLogFellerSamplers.Hours.name


class HitLogBase(LogsBase):
    Name = 'bs_hit_log'
    HumanName = 'bs-hit-log'
    DefaultPrefix = '//logs/bs-hit-log'
    DefaultSamplerName = YtLogFellerSamplers.Hours.name


class StageTimingsLogBase(LogsBase):
    Name = 'stage_timings_log'
    HumanName = 'bs-proto-stagetimings-log'
    DefaultPrefix = '//logs/bs-proto-stagetimings-log'
    DefaultSamplerName = YtLogFellerSamplers.Hours.name


Inputs = (
    HitLogBase,
    PageDictionaryBase,
    StageStatsLogBase,
    StageTimingsLogBase,
)

InputsInvert = {
    log.Name: log
    for log in Inputs
}
