from pandas import DataFrame
from plotly.graph_objs import Figure
from plotly.utils import PlotlyJSONEncoder
from typing import Callable
from typing import Iterable
from typing import Tuple
from typing import TypeVar

from sandbox.projects.yabs.ranking_group.YabsServerRankingGraphs import YabsServerRankingGraphs

import json


class GraphRenderBase(object):
    Name = None
    FileName = None

    @classmethod
    def render(cls, task: YabsServerRankingGraphs, df: DataFrame) -> str:
        raise NotImplementedError()

    @classmethod
    def figure_to_str(cls, name: str, fig: Figure) -> str:
        fullname = f'plotly_graph_{cls.FileName}_{name}'
        return '\n'.join((
            f'<div class="chart" id="{fullname}"></div>',
            f'<script>Plotly.plot("{fullname}",{json.dumps(fig, cls=PlotlyJSONEncoder)},{{}});</script>'
        ))


class SimpleGraphRender(GraphRenderBase):
    Func: Callable[[DataFrame, YabsServerRankingGraphs], Iterable[Tuple[Figure, str]]] = None

    @classmethod
    def render(cls, task: YabsServerRankingGraphs, df: DataFrame) -> str:
        res = f'<h1>{cls.Name}</h1>\n'
        for nu, (fig, title) in enumerate(cls.Func(df, task)):
            res += f'<details><summary>{title}</summary>'
            res += cls.figure_to_str(str(nu), fig) + '\n'
            res += '</details>\n'
        return res


TGraphRenderBase = TypeVar('TGraphRenderBase', bound=GraphRenderBase)
