# coding: utf-8

from .stages_graph import PLACE_SELECT_TO_NAME
from .stages_graph import Stages
from .stages_graph import generate_graph
from .stages_graph import percentile_graph
from .stages_graph import percentile_iter_buttons
from .stages_graph import transform_dataframe
from .graph_render_base import SimpleGraphRender

from math import isnan


def percentile_by_data(df, column, idx):
    return percentile_graph(df, column, idx, x=df.Data)


def iter_grouping_graphs(df, task):
    from sandbox.projects.yabs.ranking_group.YabsServerRankingGraphs.lib.stage_stats import StagesSchemas
    df = transform_dataframe(df, main_stages=['StageName', 'Data'])
    df.sort_values(['Data'], inplace=True)
    place_selects = df.PlaceSelect.unique()
    first_group = []
    second_group = []
    for stage in Stages:
        loc_a = df[df.StageName == stage]
        for select in place_selects:
            name = stage
            if select is None or isnan(select):
                loc = loc_a[loc_a.PlaceSelect.isna()]
            else:
                loc = loc_a[loc_a.PlaceSelect == select]
                name += ' For {}'.format(PLACE_SELECT_TO_NAME.get(select, 'PlaceSelect: #{}'.format(int(select))))
            if loc.empty:
                continue
            g = generate_graph(
                loc,
                percentile_graph,
                name,
                iter_buttons=percentile_iter_buttons,
                trace_generator_kwargs=dict(
                    x=loc.Data,
                ),
            )
            if g is not None:
                first_group.append(g)

            g = generate_graph(
                loc,
                percentile_graph,
                'Average Values ' + name,
                iter_buttons=percentile_iter_buttons,
                trace_generator_kwargs=dict(
                    x=loc.Data,
                    delete_first_zeros=True,
                ),
                schema=StagesSchemas.AverageValues,
            )
            if g is not None:
                second_group.append(g)

    for g in first_group:
        yield g
    for g in second_group:
        yield g


class GroupingGraphRender(SimpleGraphRender):
    Name = 'Grouping StagesStats Graph'
    FileName = 'grouping_stages_stats_graph'
    Func = iter_grouping_graphs
