# coding: utf-8

from .types import YtLogFellerSampler


SAMPLERS_DEFAULT_TEXT = 'default'


def hour_rounding(ts):
    return ts.replace(
        minute=0,
        second=0,
        microsecond=0,
    )


class Samplers(object):
    Hours = YtLogFellerSampler(
        TableFormat='%Y-%m-%dT%H:%M:%S',
        RoundingFunction=hour_rounding,
        Name='Hours',
        SubPath='1h',
    )


SamplersList = (
    Samplers.Hours,
)


SamplersInvert = {
    sampler.Name: sampler
    for sampler in SamplersList
}
