# coding: utf-8

from .inputs import HitLogBase
from .inputs import StageStatsLogBase
from .inputs import StageTimingsLogBase
from .names import SourcesNames


class SourceBaseInterface(object):
    Name = None
    MainLogName = None


class StageStatsSourceBase(SourceBaseInterface):
    Name = SourcesNames.StagesStats
    MainLogName = StageStatsLogBase.Name


class StageTimingsSourceBase(SourceBaseInterface):
    Name = SourcesNames.StageTimings
    MainLogName = StageTimingsLogBase.Name


class PMatchFailsBitsByExpsSourceBase(SourceBaseInterface):
    Name = SourcesNames.PMatchFailsBitsByExps
    MainLogName = HitLogBase.Name


class SourcesDefinitions(object):
    StagesStats = StageStatsSourceBase
    StageTimingsLog = StageTimingsSourceBase
    PMatchFailsBitsByExps = PMatchFailsBitsByExpsSourceBase
