# coding: utf-8

from jinja2 import Template

TEMPLATES_FORMAT = 'sandbox/projects/yabs/ranking_group/YabsServerRankingGraphs/templates/{}'

REPORT = 'report.html'
REQUEST = 'request.sql'


def render(filename, **kwargs):
    import library.python.resource as lpr
    data = lpr.find(TEMPLATES_FORMAT.format(filename)).decode("utf-8")
    return Template(data).render(**kwargs)


def render_report(**kwargs):
    return render(REPORT, **kwargs)


def render_request(**kwargs):
    return render(REQUEST, **kwargs)
