-- Author: {{ task.author }} {{ author_url }}
-- Task: {{ task_url }}

PRAGMA Warning("disable", "1107");
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

{% if user_definitions %}
{{ user_definitions }}
{% endif %}

{% for definition in enabled_definitions %}{{ definition.get_text(task) }}
{% endfor %}

{% for source in enabled_sources %}${{ source.Name }} = SELECT {% for select in source.iter_selects() %}
    {{ select }},{% endfor %}
FROM {{ source.get_main_log_join() }}
{% for join in source.iter_joins() %}
JOIN {{ join }}
{% endfor %}
{{ source.get_postfix_before_where() }}
WHERE TRUE{% for filtration in source.iter_filtrations() %}
    AND {{ filtration }}{% endfor %}
{{ source.get_postfix_after_where() }}
;
{% endfor %}

{% for graph in enabled_graphs %}
SELECT{% for select in graph.Selects %}
    {{ select }},{% endfor %}
{% if graph.MultiSources %}FROM ({% for source in graph.MultiSources %}
    {% if not loop.first %}UNION ALL{% endif %}
{{ source.Select.format(task=task) }}
{% endfor %}){% else %}
FROM ${{ graph.SourceName }}
{% endif %}
{% for postfix in graph.Postfixes %}{{ postfix.format(task=task) }}
{% endfor %}
INTO RESULT {{ graph.Name }};

{% endfor %}
