# coding: utf-8

from collections import namedtuple

PercentilesDescription = namedtuple(
    'PercentilesDescription',
    (
        'ColumnPrefix',
        'Value',
        'Label',
    ),
)

Aggregations = namedtuple(
    'Aggregations',
    (
        'FactoryParam',
        'Prefix',
    ),
)

StageGroup = namedtuple(
    'StageGroup',
    (
        'GroupName',
        'Columns',
    ),
)


LogDescription = namedtuple(
    'LogDescription',
    (
        'Prefix',
        'Sampler',
        'Name',
        'HumanName',
        'JoinUsing',
    )
)


YtLogFellerSampler = namedtuple(
    'YtLogFellerSampler',
    (
        'TableFormat',
        'RoundingFunction',
        'Name',
        'SubPath',
    ),
)


DictionaryDescription = namedtuple(
    'DictionaryDescription',
    (
        'Name',
        'HumanName',
        'TablePath',
        'LogsNames',
        'JoinUsing',
    )
)


LogData = namedtuple(
    'LogData',
    (
        'Name',
        'Prefix',
        'BeginTime',
        'EndTime',
        'JoinUsing',
    )
)

GraphDescription = namedtuple(
    'GraphDescription',
    (
        'Name',
        'Selects',
        'SourceName',
        'MultiSources',
        'Postfixes',
    )
)

MultiSourceDescription = namedtuple(
    'MultiSourceDescription',
    (
        'Name',
        'Select',
        'On',
    )
)

GraphParameters = namedtuple(
    'GraphParameters',
    (
        'Name',
        'Filename',
        'Function',
    )
)

GraphsElement = namedtuple(
    'GraphsElement',
    (
        'Figure',
        'GraphParameters',
    )
)

GraphSectionElement = namedtuple(
    'GraphSectionElement',
    (
        'Name',
        'Elements',
    )
)
