import logging

import sandbox.projects.release_machine.core.task_env as task_env
from sandbox import sdk2

from sandbox.projects.release_machine import input_params2 as rm_params
from sandbox.projects.release_machine.components import all as rmc
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper

logger = logging.getLogger(__name__)


class BaseTask(sdk2.Task):
    class Parameters(rm_params.ComponentName2):
        component_name = rm_params.ComponentName2.component_name(default="yabs_server")
        release_number = sdk2.parameters.Integer('Release number', required=False)

        with sdk2.parameters.Group("Startrek") as startrek_params:
            release_ticket = sdk2.parameters.String('Release startrek ticket', required=False)
            st_vault_name = sdk2.parameters.String('Startrek token vault name to send comment', default='robot-yabs-cs-b2b-startrek-token')

    class Requirements(sdk2.Requirements):
        client_tags = task_env.TaskTags.all_rm & task_env.TaskTags.startrek_client
        environments = [
            task_env.TaskRequirements.startrek_client,
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    def get_component_info(self):
        return rmc.COMPONENTS[self.Parameters.component_name]()

    def get_release_ticket(self):
        if self.Parameters.release_ticket:
            return self.Parameters.release_ticket

        st_token = sdk2.Vault.data(self.Parameters.st_vault_name)
        st_helper = STHelper(st_token)
        c_info = self.get_component_info()

        return st_helper.find_ticket_by_release_number(self.Parameters.release_number, c_info).key


class BaseReleaseTask(BaseTask):
    class Parameters(BaseTask.Parameters):
        with sdk2.parameters.Group("VCS") as vcs_params:
            start_revision = sdk2.parameters.Integer('Start revision', required=False)
            final_revision = sdk2.parameters.Integer('Final revision', required=False)
        with sdk2.parameters.Group("Testenv") as startrek_params:
            te_vault_name = sdk2.parameters.String('Testenv token', default='testenv_token')
        with sdk2.parameters.Group("Testenv") as testenv_params:
            database_name = sdk2.parameters.String('Testenv database name', default='yabs-2.0')

    def get_start_revision(self):
        c_info = self.get_component_info()
        if not self.Parameters.start_revision:
            start_revision = c_info.first_rev - 1  # Do not forge diff between previous release and first revision of current
            logger.info("No start revision specified, will use automatically obtained r%d", start_revision)
        else:
            start_revision = self.Parameters.start_revision
        return start_revision

    def get_final_revision(self):
        c_info = self.get_component_info()
        if not self.Parameters.final_revision:
            final_revision = c_info.last_rev
            logger.info("No final revision specified, will use automatically obtained r%d", final_revision)
        else:
            final_revision = self.Parameters.final_revision
        return final_revision
