import json
from datetime import datetime, timedelta

import pytz

from sandbox import sdk2
from sandbox.projects.YabsDutyScheduleGenerator import YabsDutySchedule


class DutyService(object):
    engine_first = "*Engine1"
    engine_second = "*Engine2"


def get_responsibles(service, week_start):
    """Finds YABS_DUTY_SCHEDULE resource for requested week, reads it and returns corresponding logins.
    In case of any failure returns empty list as a default value.

    :param: service: service name from schedule
    :param: week_start: week identifier, str in '%Y-%m-%d' format
    """
    schedule_resource = YabsDutySchedule.find(attrs='{{"week": "{}"}}'.format(week_start)).order(-sdk2.Resource.id).first()
    if schedule_resource is None:
        return []

    schedule_resource_data = sdk2.ResourceData(schedule_resource)
    with open(str(schedule_resource_data.path)) as schedule_file:
        schedule = json.load(schedule_file)

    return schedule.get(service, [])


def get_current_responsibles(service):
    today = datetime.now(tz=pytz.timezone("Europe/Moscow")).date()
    week_start = today - timedelta(days=today.weekday())
    week = week_start.strftime("%Y-%m-%d")
    return get_responsibles(service, week)


def get_current_engine_responsibles():
    now_dt = datetime.now(tz=pytz.timezone("Europe/Moscow"))

    week_start_dt = (now_dt - timedelta(days=now_dt.weekday())).replace(minute=0, hour=0, second=0, microsecond=0)
    duty_switch_dt = week_start_dt + timedelta(days=3, hours=16)
    duty_key = DutyService.engine_first if now_dt < duty_switch_dt else DutyService.engine_second

    return get_responsibles(duty_key, week_start_dt.strftime("%Y-%m-%d"))


def get_current_engine_prestable_responsible():
    responsibles = get_current_engine_responsibles()
    return responsibles[-1] if responsibles else None
