from sandbox.common.utils import get_task_link


class TaskInfo(object):
    __slots__ = ('type', 'id', 'url')

    def __init__(self, task_type, task_id):
        self.type = task_type
        self.id = task_id
        self.url = get_task_link(task_id)


class Link(object):
    __slots__ = ('text', 'url')

    def __init__(self, text, url):
        self.text = text
        self.url = url


class IssueInfo(object):
    __slots__ = ('text', 'url')

    def __init__(self, issue_key):
        self.text = issue_key
        self.url = 'https://st.yandex-team.ru/{}'.format(issue_key)


class BaseReportData(object):
    __slots__ = (
        'task', 'component_name', 'major_version', 'minor_version', 'tags', 'release_type', 'status',
    )

    def __init__(
            self,
            task_id=0,
            task_type='SandboxTask',
            component_name='yabs_server',
            major_version=0,
            minor_version=0,
            status=None,
            release_type='testing',
    ):

        self.task = TaskInfo(task_type, task_id) if task_id else None

        self.component_name = component_name
        self.major_version = major_version
        self.minor_version = minor_version
        self.status = status
        self.release_type = release_type
        self.tags = [component_name] + (['r{}'.format(major_version)] if major_version else []) + (['r{}_{}'.format(major_version, minor_version)] if minor_version else [])

    def as_dict(self, transport='telegram', mentions=()):
        _dict = {k: getattr(self, k) for k in self.__slots__}
        _dict.update(transport=transport, mentions=mentions)
        return _dict
