import json
import logging
import uuid

import requests


logger = logging.getLogger(__name__)


def send_message(message, juggler_token, recipients, project='YabsServerQA', template='release', abc_service='yabs_server_sandbox_tests'):
    recipient_data = {
        "abc_service": abc_service,
        "recipient": recipients,
    }

    return send_message_to_jns_service(recipient_data, project, template, message, 'send', juggler_token)


def send_message_to_channel(message, juggler_token, channel, project='YabsServerQA',  template='release'):
    recipient_data = {
        "target_project": project,
        "channel": channel,
    }

    return send_message_to_jns_service(recipient_data, project, template, message, 'send_to_channel', juggler_token)


def send_message_to_jns_service(recipient_data, project, template, message, api_method, juggler_token):
    recipient_data.update({
        "project": project,
        "template": template,
        "params": {
            "message": {
                "string_value": message,
            },
        },
        "request_id": str(uuid.uuid4()),
    })

    logging.debug('Sending data:\n%s', json.dumps(recipient_data, indent=2))

    response = requests.post(
        "https://jns.yandex-team.ru/api/messages/{api_method}".format(api_method=api_method),
        json=recipient_data,
        headers={'Authorization': 'OAuth ' + juggler_token}
    )
    logger.debug('Got response: %s', response.text)

    if not response.ok:
        logging.error("Failed to post message: %s, %s", response.status_code, response.text)

    return response
