import logging
from sandbox.projects.release_machine import rm_notify


logger = logging.getLogger(__name__)


def get_logins(task, spawn_users, transport='telegram'):
    if transport == 'telegram':
        tg_mentions = []
        for login in spawn_users:
            try:
                mention = rm_notify.get_mention(task, person=login, component_name=task.Parameters.component_name)
                tg_mentions.append(mention)
            except Exception:
                logger.warning('Cannot find %s\'s telegram login', login, exc_info=True)

        return tg_mentions
    return spawn_users
