import logging

from collections import defaultdict

logger = logging.getLogger(__name__)


def get_filtered_version(versions_info, whitelist_labels, service_labels, ignored_server_services):
    versions = defaultdict(list)
    for service_id, version in versions_info.items():
        if service_id in ignored_server_services:
            logger.warning("Version %s at '%s' was ignored due to task settings", version, service_id)
            continue
        if whitelist_labels and any([service_labels.get(service_id, {}).get(k) != v for k, v in whitelist_labels.items()]):
            logger.warning(
                "Version %s at '%s'. Labels differ: expected: %s, got %s",
                version,
                service_id,
                whitelist_labels,
                service_labels.get(service_id, {}),
            )
            continue
        versions[version].append(service_id)
    logger.info("Deployed server versions are %s", dict(versions))
    return versions
