import logging
from sandbox.common.types.misc import NotExists
from sandbox.projects.yabs.release.tasks.DeployNannyDashboard import YabsServerDeployNannyDashboard

from sandbox.projects.release_machine import rm_notify
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.yabs.release.duty.schedule import get_current_engine_responsibles


logger = logging.getLogger(__name__)
DASHBOARDS = [
    "bsfront_prestable",
    "bsfront_production",
    "bsfront_infra",
]


class DeployYabsServer(YabsServerDeployNannyDashboard):
    class Parameters(YabsServerDeployNannyDashboard.Parameters):
        dashboard_id = YabsServerDeployNannyDashboard.Parameters.dashboard_id(choices=[(d, d) for d in DASHBOARDS], default="bsfront_production")
        filter_services_by_labels = YabsServerDeployNannyDashboard.Parameters.filter_services_by_labels(default={"ctype": "prestable"})
        recipe_names = YabsServerDeployNannyDashboard.Parameters.recipe_names(default=["bsfront_universal.yaml"])
        resource_types_to_update = YabsServerDeployNannyDashboard.Parameters.resource_types_to_update(default=["BS_RELEASE_TAR"])

    def get_mention(self):
        current_engine_responsibles = get_current_engine_responsibles()
        engine_duty = current_engine_responsibles[-1] if self.Parameters.release_type in (rm_const.ReleaseStatus.testing, ) else current_engine_responsibles[0]
        try:
            mention = "@{}".format(rm_notify.get_mention(
                self,
                person=engine_duty,
                component_name=self.Parameters.component_name,
            ))
        except Exception:
            mention = "{}@".format(engine_duty)

        return mention

    @property
    def desired_version(self):
        from sandbox.projects.yabs.release.version.version import ServerVersion

        if self.Context.desired_version is NotExists:
            from sandbox.projects.yabs.release.version.sandbox_helpers import SandboxHelper
            sandbox_helper = SandboxHelper()
            self.Context.desired_version = tuple(sandbox_helper.get_full_version_from_task(self.Parameters.build_task.id))

        return ServerVersion(*self.Context.desired_version)
