from sandbox import sdk2
from sandbox.common.types import client as ctc
from sandbox.common.types.task import Status as TaskStatus, ReleaseStatus


class JustReleaseTask(sdk2.Task):
    """Mark given task as released"""

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC | ctc.Tag.MULTISLOT
        disk_space = 256  # 256 Mb
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600  # 10 min
        task = sdk2.parameters.Task("Task to release", required=True)
        release_type = sdk2.parameters.String("Release type status", default=ReleaseStatus.STABLE)
        subject = sdk2.parameters.String("Release message subject", default="Realease")

    def on_execute(self):
        task = self.Parameters.task

        if task.status not in {TaskStatus.SUCCESS, TaskStatus.RELEASING, TaskStatus.RELEASED}:
            raise sdk2.TaskFailure('Task {} is in status {}'.format(task.id, task.status))

        self.set_info('Create release for task {}:\n{}'.format(task.id, self.Parameters.subject))

        self.server.release(
            task_id=task.id,
            type=self.Parameters.release_type,
            subject=self.Parameters.subject
        )
