# -*- coding: utf-8 -*-

from jinja2 import Environment


BODY_TEMPLATE = u"""
<html>
    <body>
        <div>
        Привет.
        <br>
        {{ date }} мы зарелизили и скоро выкатим {{ major_version }}-{{ minor_version }} версию Движка, в которую попали следующие изменения:
        </div>
        <h3>Завершённые задачи</h3>
        <table>
            <tbody>
            {% for issue, summary in finalized_issues %}
            <tr>
                <td><a href="https://st.yandex-team.ru/{{ issue }}" target="_blank">{{ issue }}</a></td>
                <td>{{ summary }}</td>
            </tr>
            {% endfor %}
            </tbody>
        </table>
        <h3>Задачи в работе</h3>
        <table>
            <tbody>
            {% for issue, summary in wip_issues %}
            <tr>
                <td><a href="https://st.yandex-team.ru/{{ issue }}" target="_blank">{{ issue }}</a></td>
                <td>{{ summary }}</td>
            </tr>
            {% endfor %}
            </tbody>
        </table>
    </body>
</html>
"""
SUBJECT_TEMPLATE = u"Релиз движка r{major_version}-{minor_version}"


def create_message_body(finalized_issues, wip_issues, date, major_version, minor_version):
    env = Environment()
    template = env.from_string(BODY_TEMPLATE)
    return template.render(
        date=date.strftime("%Y.%m.%d"),
        major_version=str(major_version),
        minor_version=str(minor_version),
        finalized_issues=finalized_issues,
        wip_issues=wip_issues,
    )
