import logging

from sandbox import sdk2

from sandbox.projects.common.yabs.server.util import send_startrek_report

from sandbox.projects.yabs.release.performance.report import make_performance_report
from sandbox.projects.yabs.release.common import BaseReleaseTask


class YabsServerGetPerformanceDelta(BaseReleaseTask):

    class Parameters(BaseReleaseTask.Parameters):
        pass

    def on_execute(self):
        token = sdk2.Vault.data(self.Parameters.st_vault_name)

        performance_report = make_performance_report(self.get_start_revision(), self.get_final_revision())
        logging.debug("Performance report:\n %s", performance_report)
        send_startrek_report(token, self.get_release_ticket(), performance_report, self.id)
