import logging

from .version import ServiceStage
from .sandbox_helpers import SandboxHelper
from .samogon_helpers import SamogonHelper

logger = logging.getLogger(__name__)


NAMESPACE_STAGES = {
    "1": ServiceStage.production,
    "2": ServiceStage.production,
    "3": ServiceStage.production,
    "4": ServiceStage.production,
    "5": ServiceStage.experiment,
    "6": ServiceStage.experiment,
    "yabscs_1": ServiceStage.production,
    "yabscs_2": ServiceStage.production,
    "yabscs_3": ServiceStage.production,
    "yabscs_4": ServiceStage.production,
    "yabscs_5": ServiceStage.experiment,
    "yabscs_6": ServiceStage.experiment,
}


def get_stage_label(namespace):
    return NAMESPACE_STAGES.get(namespace, ServiceStage.unknown)


class CSVersionHelper(SandboxHelper, SamogonHelper):
    def __init__(self, *args, **kwargs):
        SandboxHelper.__init__(self, *args, **kwargs)
        SamogonHelper.__init__(self, *args, **kwargs)

    def get_cs_version(self, project, namespace):
        resource_id = self.get_meta_resource_id(project, namespace)
        version = self.get_full_version_from_resource(resource_id)
        logger.info("Controller CS version at %s_%s is %s", project, namespace, version)

        return version

    def get_cs_version_by_namespace(self, project, namespaces):
        return {
            namespace: self.get_cs_version(project, namespace)
            for namespace in namespaces
        }

    def get_deployed_cs_versions(self, project, namespace):
        resource_ids = self.get_deployed_resource_ids(project, namespace)
        versions = self.get_full_version_from_resources(resource_ids)
        logger.info("Controller CS version at %s_%s is %s", project, namespace, versions)

        return list(versions.values())

    def get_deployed_cs_versions_by_namespace(self, project, namespaces):
        return {
            namespace: self.get_deployed_cs_versions(project, namespace)
            for namespace in namespaces
        }
