from __future__ import unicode_literals

from sandbox.projects.samogon.api import SamogonClusterAPI


class SamogonHelper(object):
    CLUSTER_API_TEMPLATE = "https://clusterapi-{}{}.n.yandex-team.ru"

    def __init__(self, *args, **kwargs):
        self.__namespace_handlers = {}

    def _get_handler(self, project, namespace):
        if (project, namespace) not in self.__namespace_handlers:
            base_url = self.CLUSTER_API_TEMPLATE.format(project, namespace)
            self.__namespace_handlers[(project, namespace)] = SamogonClusterAPI(base_url)
        return self.__namespace_handlers[(project, namespace)]

    def get_meta_resource_id(self, project, namespace):
        return self._get_handler(project, namespace).get_meta_resource_id()

    def get_deployed_resource_ids(self, project, namespace):
        return self._get_handler(project, namespace).get_deployed_resource_ids()
