"""
    Here you can register any Sandbox Resource connected with Release Cycle (Resources for RM, AutoReleases, etc.)
"""
from sandbox import sdk2
from sandbox.projects.common.build.YaPackage import YaPackageResource


class DIRECT_MONITORING_PACKAGE(sdk2.Resource):
    """
        ~/arcadia/sandbox/projects/release_machine/components/configs/yabs_stat/direct_monitoring.py
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ['DIRECT_MONITORING']


class YABS_SEARCH_QUERY_MODELS_DAEMON(sdk2.Resource):
    """
        Executable search/daemons/begemot/yabs_search_query_models/yabs_search_query_models
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YABS_MODELS_SERVICES']


class YABS_LINEAR_MODELS_DAEMON(sdk2.Resource):
    """
        Executable search/daemons/begemot/yabs_linear_models/yabs_linear_models
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['YABS_MODELS_SERVICES']


class YABS_LIGHT_SHARD01_LAYER(YaPackageResource):
    """
        yabs_hit_models light shard01 configs layer
    """
    releasable = True
    releasers = ['YABS_MODELS_SERVICES']
    executable = True
    share = True


class YABS_HEAVY_SHARD01_LAYER(YaPackageResource):
    """
        yabs_hit_models heavy shard01 configs layer
    """
    releasable = True
    releasers = ['YABS_MODELS_SERVICES']
    executable = True
    share = True
