"""
    YABS-specific resource types that cannot be placed anywhere else
"""
from sandbox import sdk2


class SUPBS_HELPER(sdk2.Resource):
    """
    Full set of executables for supbs_helper
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['inngonch', 'gles', 'topero']


class YABS_SERVER_CRITICAL_PATH_TOOL(sdk2.Resource):
    """
    yabs/server/tools/critical_path
    """
    any_arch = False
    auto_backup = True


class YABS_SERVER_CRITICAL_PATH(sdk2.Resource):
    """
    output of yabs/server/tools/critical_path
    """
    any_arch = True


class YABS_MASTER_REPORT_SHARDING(sdk2.Resource):
    """
    yabs/stat/infra/clickhouse/order_sharding
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['yabsstartrek']


class YABS_ANOMALY_ANALYZER_EXECUTABLE(sdk2.Resource):
    """
    yabs/analytics/anomaly_analyzer/bin/launch
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['yabsstartrek']


class YABS_ADFOX_OWNER_SHARDING(sdk2.Resource):
    """
    yabs/stat/infra/clickhouse/adfox_owner_sharding
    """
    any_arch = False
    auto_backup = True
