import logging
import json
from urllib2 import HTTPError
import time
import traceback
from sandbox import sdk2
import requests


yabs_server_nanny_services = [
    'production_yabs_frontend_server_yabs_man1',
    'production_yabs_frontend_server_yabs_man2',
    'production_yabs_frontend_server_bs_man1',
    'production_yabs_frontend_server_bs_man2',
    'production_yabs_frontend_server_bs_man3',
    'production_yabs_frontend_server_bs_man4',
    'production_yabs_frontend_server_bs_man5',
    'production_yabs_frontend_server_bs_man6',
    'production_yabs_frontend_server_bs_man7',
    'production_yabs_frontend_server_bsrank_man1',
    'production_yabs_frontend_server_metadsp_man1',
    'production_yabs_frontend_server_metadsp_man2',
    'production_yabs_frontend_server_metadsp_man3',
    'production_yabs_frontend_server_metadsp_man4',
    'production_yabs_frontend_server_yabs_sas1',
    'production_yabs_frontend_server_yabs_sas2',
    'production_yabs_frontend_server_yabs_sas3',
    'production_yabs_frontend_server_bs_sas1',
    'production_yabs_frontend_server_bs_sas2',
    'production_yabs_frontend_server_bs_sas3',
    'production_yabs_frontend_server_bs_sas4',
    'production_yabs_frontend_server_bs_sas6',
    'production_yabs_frontend_server_bs_sas7',
    'production_yabs_frontend_server_bs_sas8',
    'production_yabs_frontend_server_bs_sas9',
    'production_yabs_frontend_server_bs_sas10',
    'production_yabs_frontend_server_bsrank_sas1',
    'production_yabs_frontend_server_yabs_vla1',
    'production_yabs_frontend_server_yabs_vla2',
    'production_yabs_frontend_server_bs_vla1',
    'production_yabs_frontend_server_bs_vla2',
    'production_yabs_frontend_server_bs_vla3',
    'production_yabs_frontend_server_bs_vla4',
    'production_yabs_frontend_server_bsrank_vla1',
    'production_yabs_frontend_server_yabs_msk_myt1',
    'production_yabs_frontend_server_bs_msk_myt1',
    'production_yabs_frontend_server_bs_msk_myt2',
    'production_yabs_frontend_server_bs_msk_myt3',
    'production_yabs_frontend_server_bs_msk_myt4',
    'production_yabs_frontend_server_bs_msk_myt5',
    'production_yabs_frontend_server_bs_msk_myt6',
    'production_yabs_frontend_server_bs_msk_myt7',
    'production_yabs_frontend_server_bs_msk_myt8',
    'production_yabs_frontend_server_bs_msk_myt9',
    'production_yabs_frontend_server_bs_msk_myt10',
    'production_yabs_frontend_server_bs_msk_myt11',
    'production_yabs_frontend_server_bsrank_msk_myt1',
    'production_yabs_frontend_server_bsrank_msk_myt2',
    'production_yabs_frontend_server_bs_msk_iva5',
    'production_yabs_frontend_server_bs_msk_iva6',
    'production_yabs_frontend_server_bs_msk_iva7',
    'production_yabs_frontend_server_bs_msk_iva8',
    'production_yabs_frontend_server_bs_msk_iva9',
    'production_yabs_frontend_server_bs_msk_iva10',
    'production_yabs_frontend_server_bs_msk_iva11',
    'production_yabs_frontend_server_bs_msk_iva12',
    'production_yabs_frontend_server_bsrank_msk_iva1',
    'experiment_yabs_frontend_server_bs_msk_iva',
    'experiment_yabs_frontend_server_yabs_msk_iva',
    'experiment_yabs_frontend_server_bs_msk_iva2',
    'experiment_yabs_frontend_server_yabs_msk_iva2',
    'prestable_yabs_frontend_server_bs_msk_iva',
    'prestable_yabs_frontend_server_yabs_msk_iva',
    'stable_yabs_frontend_server_bs_msk_iva',
    'stable_yabs_frontend_server_yabs_msk_iva',
    'preproduction_yabs_frontend_server_bs_infra_1'
]


class YabsBumpAuxService(sdk2.Task):
    description = ''

    required_ram = 100
    execution_space = 100

    class Parameters(sdk2.Task.Parameters):
        Path = sdk2.parameters.String('Resouce Nanny path', description='Local path to resource with aux service in Nanny Runtime attrs, e.g. yabs-server-base-validator.tar.gz', required=True)
        # TaskId = sdk2.parameters.Integer('Task ID', description='Sandbox task ID that generated new resource with aux service', required=True)
        # ResourceId = sdk2.parameters.Integer('Resource ID', description='Sandbox resource ID of new resource with aux service', required=True)
        Resource = sdk2.parameters.Resource('Sandbox resource ID of resource with aux service', required=True)
        NannyTokenVaultName = sdk2.parameters.String('Vault name of Nanny token', description='Nanny token vault name to manage services', default='robot-bs-autoadmin-nanny-token')
        Services = sdk2.parameters.String('List of services to be bumped (comma-separated)', default=','.join(yabs_server_nanny_services), multiline=True)
        NannyComment = sdk2.parameters.String(
            'Comment to Nanny snapshot', description='Custom comment to Nanny snapshot instead of automatically generated (optional) e.g. Bump BUILD_BANNER_SERVER to 262004827', default=None)
        PrepareFlag = sdk2.parameters.Bool('Prepare generated snapshots for services after bump')
        STTicket = sdk2.parameters.String('ST ticket', description='Startrek ticket to leave a comment after finishing (if it is specified)', default=None)
        StartrekTokenVaultName = sdk2.parameters.String('Vault name of Startrek token', description='Startrek token vault name to send comment', default='robot-bs-autoadmin-startrek-token')

    def nanny_get(self, nanny_token, url_part):
        nanny_url = 'http://nanny.yandex-team.ru/'
        url = nanny_url + url_part
        auth_header = 'OAuth ' + nanny_token
        success = False
        while not success:
            try:
                r = requests.get(
                    url,
                    headers={
                        'Authorization': auth_header
                    }
                )
                response = r.json()
                return response
            except HTTPError:
                logging.error('Failed to fetch {}, retry after 5 seconds'.format(url))
                logging.error(traceback.format_exc())
                time.sleep(5)

    def nanny_post(self, nanny_token, url_part, post_data, request_func=requests.post):
        nanny_url = 'http://nanny.yandex-team.ru/'
        url = nanny_url + url_part
        auth_header = 'OAuth ' + nanny_token
        success = False
        while not success:
            try:
                r = request_func(
                    url,
                    data=post_data,
                    headers={
                        'Authorization': auth_header,
                        'Content-Type': 'application/json'
                    }
                )
                response = r.json()
                return response
            except HTTPError:
                logging.error('Failed to post to {}, retry after 5 seconds'.format(url))
                logging.error(traceback.format_exc())
                time.sleep(5)

    def bump_snapshot(self, nanny_token, path, task_id, resource_id, service):
        nanny_url_part = 'v2/services/{}/runtime_attrs/'.format(service)
        response = self.nanny_get(nanny_token, nanny_url_part)
        if response:
            snapshot_id = response['_id']
            content = response['content']
            found = False
            for resource in content['resources']['sandbox_files']:
                if resource['local_path'] == path:
                    logging.info('Found resource with path {}. Old task_id: {}, resource_id: {}'.format(path, resource.get('task_id'), resource.get('resource_id')))
                    resource['task_id'] = str(task_id)
                    resource['resource_id'] = str(resource_id)
                    logging.info('Replaced resource with path {}. New task_id: {}, resource_id: {}'.format(path, resource['task_id'], resource['resource_id']))
                    found = True

            if not found:
                logging.error('Have not found resource with path {} for service {}!'.format(path, service))
                return None

            bump_command = {
                'snapshot_id': snapshot_id,
                'content': content,
                'comment': 'Bump {} to {} (task: {})'.format(path, resource_id, task_id)
                if self.Parameters.NannyComment is None or self.Parameters.NannyComment == '' else self.Parameters.NannyComment
            }

            response = self.nanny_post(nanny_token, nanny_url_part, json.dumps(bump_command), request_func=requests.put)
            if response:
                logging.debug(str(response))
                snapshot_id = response['_id']
                logging.info('{} created snapshot_id={}'.format(service, snapshot_id))
                return snapshot_id

    def prepare_snapshot(self, nanny_token, service, snapshot_id):
        response = self.nanny_get(nanny_token, 'v2/services/{}/state/'.format(service))
        if response:
            found = False
            snapshot_state = None
            for snapshot in response['current_state']['content']['active_snapshots']:
                if snapshot['snapshot_id'] == snapshot_id:
                    logging.info('Found snapshot with id {}. Its state is {}'.format(snapshot_id, snapshot['state']))
                    snapshot_state = snapshot['state']

            if not found:
                logging.debug('Have not found snapshot with id {} for service {}'.format(snapshot_id, service))

            if snapshot_state not in ('ACTIVATING', 'PREPARING', 'ACTIVE', 'PREPARED'):
                prepare_command = {
                    'content': {
                        'snapshot_id': snapshot_id,
                        'state': 'PREPARED',
                        'comment': 'Prepare {} snapshot!'.format(snapshot_id),
                        'recipe': 'common'
                    },
                    'type': 'SET_SNAPSHOT_STATE'
                }
                response = self.nanny_post(nanny_token, 'v2/services/{}/events/'.format(service), json.dumps(prepare_command))
                if response:
                    logging.debug(str(response))
                    snapshot_id = response['_id']
                    logging.info('{} prepared snapshot_id={}'.format(service, snapshot_id))
                    return snapshot_id
            else:
                logging.error('Snapshot {} of service {} is already in state {}'.format(snapshot_id, service, snapshot_state))

    def bump_services(self, nanny_token, path, task_id, resource_id, services, prepare_services=False):
        success_services = []
        fail_services = []
        prepare_success_services = []
        prepare_fail_services = []
        for service in services:
            service = service.strip()
            snapshot_id = None
            try:
                logging.info('{} started bump'.format(service))
                snapshot_id = self.bump_snapshot(nanny_token, path, task_id, resource_id, service)
                if snapshot_id:
                    logging.info('Success')
                    success_services.append(service)
                else:
                    raise Exception('Something went wrong')
            except Exception:
                logging.error('bump failed for service {}!'.format(service))
                logging.debug(traceback.format_exc())
                fail_services.append(service)

            if snapshot_id and prepare_services:
                try:
                    logging.info('{} started preparing'.format(service))
                    snapshot_id = self.prepare_snapshot(nanny_token, service, snapshot_id)
                    if snapshot_id:
                        logging.info('Succesfully prepared')
                        prepare_success_services.append(service)
                    else:
                        raise Exception('Something went wrong while preparing')
                except Exception:
                    logging.error('prepare failed for service {}!'.format(service))
                    logging.debug(traceback.format_exc())
                    prepare_fail_services.append(service)

        return {
            'success': success_services,
            'fail': fail_services,
            'prepare_success': prepare_success_services,
            'prepare_fail': prepare_fail_services
        }

    def send_startrek_report(self, st_ticket, st_report):
        logging.info('Try to add Startrek comment')
        from projects.common.geosearch.startrek import StartrekClient
        token = sdk2.Vault.data(self.Parameters.StartrekTokenVaultName)
        self.startrek_client = StartrekClient(token)
        self.startrek_client.add_comment(st_ticket, st_report)

    def on_execute(self):

        logging.info('Start')

        res = self.bump_services(
            nanny_token=sdk2.Vault.data(self.Parameters.NannyTokenVaultName),
            path=self.Parameters.Path,
            task_id=self.Parameters.Resource.task_id,
            resource_id=self.Parameters.Resource.id,
            services=self.Parameters.Services.split(','),
            prepare_services=self.Parameters.PrepareFlag
        )

        if self.Parameters.STTicket is not None and self.Parameters.STTicket != '':
            self.send_startrek_report(self.Parameters.STTicket, 'Successfully bumped services:\n    {}\nFailed to bump services:\n    {}'.format(
                '\n    '.join(res['success']), '\n    '.join(res['fail'])))
            if self.Parameters.PrepareFlag:
                self.send_startrek_report(self.Parameters.STTicket, 'Successfully prepared services:\n    {}\nFailed to prepare services:\n    {}'.format(
                    '\n    '.join(res['prepare_success']), '\n    '.    join(res['prepare_fail'])))

        logging.info('Finish')
