'''
Information about Python command.
'''

from __future__ import absolute_import, division, print_function

import shlex
import six


def command_info(command):
    '''
    Returns information about shell command.

    Returned value after conversion to JSON is always a list of strings.

    :param command: command
    :type command: str | Iterable[str]
    :return: tracing information about command
    :rtype: list[str]
    '''
    if isinstance(command, six.string_types):
        command = shlex.split(command)
    return list(map(str, command))
