'''
Make values JSON-compatible.
'''

from __future__ import absolute_import, division, print_function

import six

from sandbox.projects.yabs.sandbox_task_tracing.info.symbol import symbol_info


def jsonified(value, __immutable_types=((type(None), bool, int, float) + six.string_types)):
    '''
    Returns JSON-compatible copy of its argument.

    Depending on type of `value`, does the following:
    * immutable JSON-compatible types returns as is;
    * converts mappings to `dict`;
    * converts sized containers (do not include iterators) to `list`
    * converts all other objects to `dict(type=symbol_info(type(value)), repr=repr(value))`

    :param value: arbitrary value
    :return: JSON-compatible copy of `value`
    '''
    return (
        value if isinstance(value, __immutable_types) else
        {six.text_type(key): jsonified(value) for key, value in six.iteritems(value)} if hasattr(value, 'items') else
        list(map(jsonified, value)) if all(hasattr(value, name) for name in ('__iter__', '__len__')) else
        dict(type=symbol_info(type(value)), repr=repr(value))
    )
