'''
Information about Sandbox resource.
'''

from __future__ import absolute_import, division, print_function

from sandbox.projects.yabs.sandbox_task_tracing.info.symbol import symbol_info


def resource_info(resource):
    '''
    Returns information about Sandbox resource object.

    Returned value after conversion to JSON:
    ```json
    {
        "id": <resource id>,                                # integer
        "path": <resource path>,                            # string
        "size": <resource size>,                            # integer
        "state": <resource state>,                          # string
        "type": <Python resource object type info>          # as returned by `.symbol.symbol_info`
    }
    ```

    :param sandbox.sdk2.resource.AbstractResource resource: resource object
    :return: tracing information in the format described above
    :rtype: dict
    '''
    return dict(
        id=resource.id,
        path=(str(resource.path) if hasattr(resource, 'path') else None),
        size=getattr(resource, 'size', None),
        state=getattr(resource, 'state', None),
        type=symbol_info(type(resource)),
    )
