'''
Information about Python symbol.
'''

from __future__ import absolute_import, division, print_function


def symbol_info(symbol):
    '''
    Returns information about Python symbol (function or type).

    Returned value after conversion to JSON:
    ```json
    {
        "module": <symbol module name>,                     # `symbol.__module__`
        "name": <symbol name>,                              # `symbol.__name__`
        "qualname": <symbol qualified name>                 # `symbol.__qualname__`, only if present (e.g. in Python 3)
    }
    ```

    :param symbol: Python symbol, function or type
    :return: tracing information in the format described above
    :rtype: dict
    '''
    result = dict(
        name=symbol.__name__,
        module=symbol.__module__,
    )
    if hasattr(symbol, '__qualname__'):
        result.update(qualname=symbol.__qualname__)
    return result
