'''
Sandbox task tracing library: wrappers for generic sandbox objects.
'''

from __future__ import absolute_import, division, print_function

from sandbox.projects.yabs.sandbox_task_tracing import trace_new_resources, trace_new_tasks


def enqueue_task(task):
    with trace_new_tasks() as new_tasks:
        task.enqueue()
        new_tasks.append(task)
    return task


def new_resource(resource_type, *args, **kwargs):
    with trace_new_resources() as new_resources:
        resource = resource_type(*args, **kwargs)
        new_resources.append(resource)
        return resource
