'''
Sandbox task tracing library: wrappers for sandbox.sdk2 module.
'''

from __future__ import absolute_import, division, print_function

from sandbox.projects.yabs.sandbox_task_tracing import trace
from sandbox.projects.yabs.sandbox_task_tracing.info import resource_info

from sandbox.sdk2 import ResourceData


def new_resource_data(resource, *args, **kwargs):
    with trace('new_resource_data', info=dict(resource=resource_info(resource))):
        return ResourceData(resource, *args, **kwargs)


def make_resource_ready(resource, *args, **kwargs):
    with trace('make_resource_ready', info=dict(resource=resource_info(resource))):
        return ResourceData(resource, *args, **kwargs).ready()
