from __future__ import absolute_import, division, print_function

import collections


class TraceRecord(collections.namedtuple('TraceRecord', (
    'record',
    'parent',
    'started',
    'finished',
    'type',
    'info',
))):
    '''
    Single trace record (executed code block or like).

    :ivar int record: record id
    :ivar int parent: parent record id
    :ivar int started: integer microseconds since unix epoch
    :ivar int finished: integer microseconds since unix epoch
    :ivar str type: record type
    :ivar dict info: JSON-compatible, keys depend on `type` (see `.info` for details)
    '''

    __slots__ = ()
