"""Yabs SBYT dashboard."""
from sandbox import sdk2

import sandbox.common.types.client as ctc
from sandbox.projects.common.build import YaMake
from sandbox.projects.common.nanny import nanny


class YabsSbytDashboardResource(sdk2.Resource):
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['abordonos', 'inngonch', 'astyts', 'danilgrig', 'zasalamel', 'kacher', 'mafanasev']
    release_subscribers = ['abordonos', 'astyts', 'kacher', 'mafanasev']


class YabsSbytDashboardBuild(nanny.ReleaseToNannyTask, YaMake.YaMakeTask):
    type = 'YABS_SBYT_DASHBOARD_BUILD'
    client_tags = ctc.Tag.Group.LINUX
    cores = 24

    def initCtx(self):
        return {
            'targets': 'yabs/sbyt/dashboard/bin',
            'arts': 'bin/yabs-sbyt-dashboard',
            'result_single_file': True,
            'result_rt': str(YabsSbytDashboardResource),
            'result_rd': 'YaBS SBYT Dasboard',
            'test': True,
        }


__Task__ = YabsSbytDashboardBuild
